
> Saya sedang membangun sistem warehouse/gudang berbasis web menggunakan PHP murni untuk pemula.
>
> Karakteristik sistem:
>
> * PHP procedural (tanpa OOP)
> * Tanpa function
> * Tanpa session
> * Tanpa framework
> * Struktur sederhana, 1 file = 1 fungsi halaman
> * Tujuan utama: pembelajaran & tugas kuliah, bukan produksi
>
> Sistem ini mensimulasikan alur gudang e-commerce seperti DC Shopee (versi sederhana), dengan aktor:
>
> 1. Admin
> 2. Petugas Gudang Barang Masuk
> 3. Petugas Gudang Barang Keluar
>
> Kondisi sistem saat ini:
>
> * Login sederhana sudah ada (tanpa session, hanya redirect berdasarkan role)
> * Database MySQL sudah ada dan terhubung
> * CRUD paket sudah berjalan
> * Dashboard menampilkan data real dari database
>
> Struktur utama data:
>
> * paket (inti sistem, berbasis nomor resi)
> * rak
> * zona
>
> Alur bisnis yang sudah diterapkan:
>
> * Petugas masuk menginput paket per nomor resi
> * Paket disimpan di rak dan zona tertentu
> * Petugas keluar mengeluarkan paket berdasarkan SLA pengiriman
> * SLA:
>
>   * Instan ≤ 3 jam
>   * Same Day ≤ 23:59
>   * Cargo ≥ 3 hari
>
> Dashboard:
>
> * Dashboard umum menampilkan paket masuk & keluar (realtime refresh)
> * Dashboard admin menampilkan monitoring paket dan statistik dasar
> * Dashboard petugas masuk menampilkan paket yang sudah diinput
> * Dashboard petugas keluar menampilkan paket yang siap dikirim
>
> Yang BELUM dibuat dan ingin dikembangkan:
>
> * Grafik harian paket masuk & keluar (versi pemula)
> * Validasi keterlambatan SLA
> * Tampilan UI lebih rapi (Bootstrap ringan)
> * Fitur persetujuan retur oleh admin
> * Log aktivitas (riwayat perubahan status paket)
>
> Tolong bantu saya melanjutkan pengembangan sistem ini dengan:
>
> * Tetap mempertahankan gaya PHP pemula
> * Tidak mengubah arsitektur yang sudah ada
> * Menambahkan fitur secara bertahap dan terpisah per file
> * Kode harus mudah dibaca dan mudah dipahami oleh mahasiswa pemula

---

Prompt ini **sudah konsisten** dengan seluruh percakapan kita dari awal sampai akhir.

---

# 2. PENJELASAN KESELURUHAN SISTEM (UNTUK README / LAPORAN)

## 2.1 Gambaran Umum Sistem

Sistem ini adalah **simulasi Warehouse Management System (WMS)** versi sederhana yang meniru alur operasional gudang e-commerce:

* Fokus pada **alur fisik paket**
* Berbasis **nomor resi**
* Menggunakan **rak dan zona**
* Menerapkan **aturan SLA pengiriman**

Sistem sengaja dibuat **tidak kompleks** agar:

* Mudah dipelajari
* Mudah dikembangkan
* Cocok untuk tugas kuliah dan demo

---

## 2.2 Alur Sistem dari Awal Sampai Akhir

### 1. Login

* User login menggunakan username & password
* Sistem mengecek role:

  * `admin`
  * `petugas_masuk`
  * `petugas_keluar`
* Redirect ke dashboard masing-masing
* Tidak menggunakan session (sesuai batasan pemula)

---

### 2. Petugas Gudang Barang Masuk

* Menginput data paket:

  * Nomor resi
  * Penerima
  * Alamat
  * Nama barang
  * Jenis barang
  * Tipe pengiriman
  * Rak/zona
* Sistem otomatis:

  * Menyimpan ke tabel `paket`
  * Memberi status:

    * `status_pengiriman = Menunggu`
    * `status_rak = Disimpan`
* Data langsung tampil di dashboard

---

### 3. Penyimpanan di Rak & Zona

* Setiap paket terasosiasi dengan:

  * 1 rak
  * 1 zona
* Ini mensimulasikan **penataan fisik gudang**

---

### 4. Petugas Gudang Barang Keluar

* Melihat daftar paket yang masih disimpan
* Sistem menghitung waktu sejak paket masuk
* Sistem menentukan:

  * Boleh dikirim sekarang
  * Atau masih menunggu
* Jika dikirim:

  * Status berubah menjadi `Dikirim`
  * Status rak menjadi `Keluar`

---

### 5. Admin

* Tidak menginput data
* Bertugas memonitor:

  * Total paket masuk
  * Paket menunggu
  * Paket dikirim
* Melihat 25 data terakhir
* Menjadi pusat kontrol operasional

---

## 2.3 Kondisi Source Code Saat Ini (STATUS PROYEK)

### SUDAH ADA

✔ Koneksi database
✔ Struktur tabel inti
✔ CRUD paket berjalan
✔ Dashboard realtime
✔ Pemisahan peran user
✔ Logika SLA dasar
✔ Rak & zona gudang

### BELUM ADA (RUANG PENGEMBANGAN)

❌ Grafik harian (chart)
❌ Deteksi keterlambatan otomatis
❌ Retur barang
❌ Log aktivitas paket
❌ UI modern (Bootstrap)
❌ Keamanan (session, hashing password)

Ini **sengaja** belum dibuat agar:

* Bisa jadi bahan pengembangan bertahap
* Bisa dijadikan topik lanjutan / skripsi mini / presentasi

---

## 2.4 Rekomendasi Pengembangan Bertahap

Urutan pengembangan yang **aman & masuk akal**:

1. Grafik harian paket masuk & keluar
2. Penanda paket terlambat (warna merah)
3. Persetujuan retur oleh admin
4. Log aktivitas paket
5. Migrasi ke session & function (tahap lanjut)

---

## PENUTUP (PENTING)

Dengan kondisi sekarang:

* Sistem ini **sudah lengkap secara alur**
* Sudah **masuk akal secara logistik**
* Sudah **cukup matang untuk dipresentasikan**
* Dan **sangat siap dilanjutkan oleh GitHub Copilot**
