<?php include "koneksi.php"; ?>
<!DOCTYPE html>
<html>
<head>
<title>Grafik Paket Harian</title>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
body { font-family: Arial, sans-serif; margin: 20px; }
.container { max-width: 1200px; margin: 0 auto; }
.chart-box { background: #fff; padding: 20px; margin: 20px 0; border: 1px solid #ddd; border-radius: 5px; }
h2 { color: #333; }
.nav { margin-bottom: 20px; }
.nav a { display: inline-block; padding: 10px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 3px; margin-right: 10px; }
.nav a:hover { background: #0056b3; }
</style>
</head>
<body>

<div class="container">
<h1>📊 Grafik Paket Harian</h1>

<div class="nav">
<a href="dashboard_admin.php">← Kembali ke Dashboard Admin</a>
</div>

<!-- GRAFIK PAKET MASUK PER HARI (7 HARI TERAKHIR) -->
<div class="chart-box">
<h2>Paket Masuk (7 Hari Terakhir)</h2>
<canvas id="chartMasuk"></canvas>
</div>

<!-- GRAFIK PAKET KELUAR PER HARI (7 HARI TERAKHIR) -->
<div class="chart-box">
<h2>Paket Keluar (7 Hari Terakhir)</h2>
<canvas id="chartKeluar"></canvas>
</div>

<!-- GRAFIK PERBANDINGAN MASUK VS KELUAR -->
<div class="chart-box">
<h2>Perbandingan Paket Masuk vs Keluar</h2>
<canvas id="chartPerbandingan"></canvas>
</div>

</div>

<?php
// QUERY: Data paket masuk per hari (7 hari terakhir)
$q_masuk = mysqli_query($koneksi,"
SELECT DATE(waktu_masuk) as tgl, COUNT(*) as jumlah
FROM paket
WHERE waktu_masuk >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
GROUP BY DATE(waktu_masuk)
ORDER BY tgl ASC
");

$labels_masuk = array();
$data_masuk = array();
while ($d = mysqli_fetch_array($q_masuk)) {
    $labels_masuk[] = $d['tgl'];
    $data_masuk[] = $d['jumlah'];
}

// QUERY: Data paket keluar per hari (7 hari terakhir)
$q_keluar = mysqli_query($koneksi,"
SELECT DATE(waktu_masuk) as tgl, COUNT(*) as jumlah
FROM paket
WHERE status_pengiriman='Dikirim' AND waktu_masuk >= DATE_SUB(CURDATE(), INTERVAL 7 DAY)
GROUP BY DATE(waktu_masuk)
ORDER BY tgl ASC
");

$labels_keluar = array();
$data_keluar = array();
while ($d = mysqli_fetch_array($q_keluar)) {
    $labels_keluar[] = $d['tgl'];
    $data_keluar[] = $d['jumlah'];
}

// Convert ke JSON untuk Chart.js
$labels_masuk_json = json_encode($labels_masuk);
$data_masuk_json = json_encode($data_masuk);
$labels_keluar_json = json_encode($labels_keluar);
$data_keluar_json = json_encode($data_keluar);
?>

<script>
// CHART 1: Paket Masuk
const ctx1 = document.getElementById('chartMasuk').getContext('2d');
new Chart(ctx1, {
    type: 'bar',
    data: {
        labels: <?php echo $labels_masuk_json; ?>,
        datasets: [{
            label: 'Paket Masuk',
            data: <?php echo $data_masuk_json; ?>,
            backgroundColor: '#4CAF50',
            borderColor: '#2E7D32',
            borderWidth: 2
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: true }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: { stepSize: 1 }
            }
        }
    }
});

// CHART 2: Paket Keluar
const ctx2 = document.getElementById('chartKeluar').getContext('2d');
new Chart(ctx2, {
    type: 'bar',
    data: {
        labels: <?php echo $labels_keluar_json; ?>,
        datasets: [{
            label: 'Paket Keluar (Dikirim)',
            data: <?php echo $data_keluar_json; ?>,
            backgroundColor: '#FF9800',
            borderColor: '#E65100',
            borderWidth: 2
        }]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: true }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: { stepSize: 1 }
            }
        }
    }
});

// CHART 3: Perbandingan Masuk vs Keluar
const ctx3 = document.getElementById('chartPerbandingan').getContext('2d');
new Chart(ctx3, {
    type: 'line',
    data: {
        labels: <?php echo $labels_masuk_json; ?>,
        datasets: [
            {
                label: 'Masuk',
                data: <?php echo $data_masuk_json; ?>,
                borderColor: '#4CAF50',
                backgroundColor: 'rgba(76, 175, 80, 0.1)',
                borderWidth: 2,
                tension: 0.4
            },
            {
                label: 'Keluar',
                data: <?php echo $data_keluar_json; ?>,
                borderColor: '#FF9800',
                backgroundColor: 'rgba(255, 152, 0, 0.1)',
                borderWidth: 2,
                tension: 0.4
            }
        ]
    },
    options: {
        responsive: true,
        plugins: {
            legend: { display: true }
        },
        scales: {
            y: {
                beginAtZero: true,
                ticks: { stepSize: 1 }
            }
        }
    }
});
</script>

</body>
</html>
