<?php include "koneksi.php"; ?>
<!DOCTYPE html>
<html>
<head>
<title>Input Paket</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background: #f5f5f5; }
.container { max-width: 600px; margin: 50px auto; }
.card { border-radius: 10px; box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1); }
.btn-submit { width: 100%; padding: 10px; font-weight: bold; }
.alert { margin-top: 20px; }
</style>
</head>
<body>

<div class="container">
<div class="card p-4">
<h2 class="mb-4">📦 Input Paket Masuk</h2>

<form method="post">
<div class="mb-3">
<label class="form-label">No Resi</label>
<input type="text" class="form-control" name="resi" required>
</div>

<div class="mb-3">
<label class="form-label">Nama Penerima</label>
<input type="text" class="form-control" name="penerima" required>
</div>

<div class="mb-3">
<label class="form-label">Alamat</label>
<textarea class="form-control" name="alamat" rows="3" required></textarea>
</div>

<div class="mb-3">
<label class="form-label">Nama Barang</label>
<input type="text" class="form-control" name="barang" required>
</div>

<div class="mb-3">
<label class="form-label">Jenis Barang</label>
<select class="form-select" name="jenis" required>
<option selected>Kecil</option>
<option>Besar</option>
</select>
</div>

<div class="mb-3">
<label class="form-label">Tipe Pengiriman</label>
<select class="form-select" name="tipe" required>
<option selected>Instan</option>
<option>Same Day</option>
<option>Cargo</option>
</select>
</div>

<div class="mb-3">
<label class="form-label">Rak Penyimpanan</label>
<select class="form-select" name="id_rak" required>
<option value="">-- Pilih Rak --</option>
<?php
$rak_query = mysqli_query($koneksi, "SELECT id_rak, nama_rak FROM rak ORDER BY nama_rak");
while ($rak = mysqli_fetch_array($rak_query)) {
    echo "<option value='".$rak['id_rak']."'>".$rak['nama_rak']."</option>";
}
?>
</select>
</div>

<button type="submit" name="simpan" class="btn btn-primary btn-submit">💾 Simpan Paket</button>
</form>

<?php
if (isset($_POST['simpan'])) {
    $resi = $_POST['resi'];
    $penerima = $_POST['penerima'];
    $alamat = $_POST['alamat'];
    $barang = $_POST['barang'];
    $jenis = $_POST['jenis'];
    $tipe = $_POST['tipe'];
    $id_rak = $_POST['id_rak'];

    mysqli_query($koneksi,
        "INSERT INTO paket VALUES
        (NULL,'$resi','$penerima','$alamat','$barang','$jenis','$tipe','Menunggu','$id_rak',NULL,NOW())"
    );

    // LOG AKTIVITAS
    include "log_helper.php";
    $id_paket_baru = mysqli_insert_id($koneksi);
    insertLog($koneksi, 
        $id_paket_baru, 
        'Input Paket', 
        'Paket masuk - Resi: ' . $resi . ', Penerima: ' . $penerima . ', Tipe: ' . $tipe,
        null,
        'Menunggu',
        'petugas_masuk'
    );

    echo "<div class='alert alert-success alert-dismissible fade show' role='alert'>
            <strong>✓ Sukses!</strong> Paket berhasil dimasukkan.
            <button type='button' class='btn-close' data-bs-dismiss='alert'></button>
          </div>";
}
?>

</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>