<?php
// FILE HELPER UNTUK LOGGING AKTIVITAS
// Gunakan fungsi ini di file-file lain untuk mencatat aktivitas

// Fungsi untuk insert log aktivitas
function insertLog($koneksi, $id_paket, $jenis, $deskripsi, $status_sebelum = null, $status_sesudah = null, $user_id = null) {
    $jenis = mysqli_real_escape_string($koneksi, $jenis);
    $deskripsi = mysqli_real_escape_string($koneksi, $deskripsi);
    $status_sebelum = $status_sebelum ? mysqli_real_escape_string($koneksi, $status_sebelum) : null;
    $status_sesudah = $status_sesudah ? mysqli_real_escape_string($koneksi, $status_sesudah) : null;
    $user_id = $user_id ? mysqli_real_escape_string($koneksi, $user_id) : 'Sistem';
    
    $query = "INSERT INTO log_aktivitas (id_paket, jenis_aktivitas, deskripsi, status_sebelum, status_sesudah, waktu_log, user_id)
              VALUES ('$id_paket', '$jenis', '$deskripsi', ";
    
    $query .= ($status_sebelum !== null) ? "'$status_sebelum', " : "NULL, ";
    $query .= ($status_sesudah !== null) ? "'$status_sesudah', " : "NULL, ";
    
    $query .= "NOW(), '$user_id')";
    
    return mysqli_query($koneksi, $query);
}

// CONTOH PENGGUNAAN DI FILE LAIN:
/*

// Di input_paket.php, setelah INSERT paket:
include "log_helper.php";

$id_paket_baru = mysqli_insert_id($koneksi);
insertLog($koneksi, 
    $id_paket_baru, 
    'Input Paket', 
    'Paket masuk dengan no. resi ' . $resi . ', penerima: ' . $penerima,
    null,
    'Menunggu',
    'petugas_masuk'
);

// Di kirim.php, setelah UPDATE status Dikirim:
include "log_helper.php";

$status_lama = 'Menunggu';
$status_baru = 'Dikirim';
insertLog($koneksi,
    $id_paket,
    'Pengiriman Paket',
    'Paket dengan no. resi ' . $no_resi . ' telah dikirim',
    $status_lama,
    $status_baru,
    'petugas_keluar'
);

// Di retur_approval.php, setelah retur disetujui:
include "log_helper.php";

insertLog($koneksi,
    $id_paket,
    'Permintaan Retur',
    'Retur paket disetujui dengan alasan: ' . $alasan,
    'Dikirim',
    'Retur Disetujui',
    'admin'
);

*/

?>
