<?php include "koneksi.php"; ?>
<!DOCTYPE html>
<html>
<head>
<title>Monitoring SLA Paket</title>
<style>
body { font-family: Arial, sans-serif; margin: 20px; background: #f5f5f5; }
.container { max-width: 1200px; margin: 0 auto; }
h1 { color: #333; }
table { width: 100%; border-collapse: collapse; background: white; margin: 20px 0; }
th, td { padding: 12px; text-align: left; border: 1px solid #ddd; }
th { background: #007bff; color: white; }
tr:hover { background: #f9f9f9; }

.status-tepat { background: #d4edda; color: #155724; font-weight: bold; }
.status-terlambat { background: #f8d7da; color: #721c24; font-weight: bold; }
.status-dikirim { background: #d1ecf1; color: #0c5460; }

.filter-btn { padding: 8px 15px; margin: 10px 5px 10px 0; background: #007bff; color: white; border: none; border-radius: 3px; cursor: pointer; }
.filter-btn:hover { background: #0056b3; }
.filter-btn.active { background: #28a745; }

.summary { display: flex; gap: 20px; margin: 20px 0; }
.summary-box { background: white; padding: 20px; border-radius: 5px; flex: 1; border-left: 4px solid #007bff; }
.summary-box h3 { margin: 0 0 10px 0; color: #666; }
.summary-box .number { font-size: 28px; font-weight: bold; color: #007bff; }
.summary-box.warning .number { color: #ff6b6b; }
.summary-box.success .number { color: #51cf66; }

.nav { margin-bottom: 20px; }
.nav a { display: inline-block; padding: 10px 15px; background: #007bff; color: white; text-decoration: none; border-radius: 3px; margin-right: 10px; }
.nav a:hover { background: #0056b3; }
</style>
</head>
<body>

<div class="container">
<h1>⏰ Monitoring SLA Paket</h1>

<div class="nav">
<a href="dashboard_admin.php">← Kembali ke Dashboard Admin</a>
</div>

<!-- SUMMARY BOXES -->
<div class="summary">
    <div class="summary-box">
        <h3>Total Paket Menunggu</h3>
        <div class="number" id="total-menunggu">0</div>
    </div>
    <div class="summary-box warning">
        <h3>Paket Terlambat</h3>
        <div class="number" id="total-terlambat">0</div>
    </div>
    <div class="summary-box success">
        <h3>Paket Tepat Waktu</h3>
        <div class="number" id="total-tepat">0</div>
    </div>
</div>

<!-- FILTER BUTTONS -->
<div>
<button class="filter-btn active" onclick="filterStatus('semua')">Semua</button>
<button class="filter-btn" onclick="filterStatus('terlambat')">Terlambat Saja</button>
<button class="filter-btn" onclick="filterStatus('tepat')">Tepat Waktu</button>
</div>

<!-- TABLE -->
<table id="tabelSLA">
<tr>
<th>No Resi</th>
<th>Penerima</th>
<th>Tipe Pengiriman</th>
<th>Waktu Masuk</th>
<th>Jam Masuk</th>
<th>Batas Waktu</th>
<th>Waktu Tersisa</th>
<th>Status SLA</th>
</tr>
</table>

</div>

<?php
// Query semua paket yang belum dikirim (status = Menunggu)
$q = mysqli_query($koneksi,"
SELECT * FROM paket 
WHERE status_pengiriman='Menunggu'
ORDER BY waktu_masuk DESC
");

$total_menunggu = 0;
$total_terlambat = 0;
$total_tepat = 0;

$data_paket = array();

while ($d = mysqli_fetch_array($q)) {
    $total_menunggu++;
    
    $resi = $d['no_resi'];
    $penerima = $d['nama_penerima'];
    $tipe = $d['tipe_pengiriman'];
    $waktu_masuk = $d['waktu_masuk'];
    
    // Parse waktu masuk
    $waktu_masuk_obj = new DateTime($waktu_masuk);
    $jam_masuk = $waktu_masuk_obj->format('H:i');
    
    // Hitung batas waktu berdasarkan tipe pengiriman
    $waktu_batas = new DateTime($waktu_masuk);
    
    if ($tipe == 'Instan') {
        $waktu_batas->modify('+3 hours');
        $label_batas = '+3 jam';
    } elseif ($tipe == 'Same Day') {
        $waktu_batas->modify('+1 day');
        $waktu_batas->setTime(23, 59, 59);
        $label_batas = 'Hari yang sama';
    } else { // Cargo
        $waktu_batas->modify('+3 days');
        $label_batas = '+3 hari';
    }
    
    // Hitung waktu tersisa
    $sekarang = new DateTime();
    $interval = $sekarang->diff($waktu_batas);
    
    if ($sekarang > $waktu_batas) {
        // TERLAMBAT
        $waktu_tersisa = "Terlambat " . $interval->format('%d hari %h jam');
        $status_sla = 'TERLAMBAT';
        $status_class = 'status-terlambat';
        $total_terlambat++;
    } else {
        // MASIH ADA WAKTU
        if ($interval->d > 0) {
            $waktu_tersisa = $interval->d . " hari " . $interval->h . " jam";
        } else {
            $waktu_tersisa = $interval->h . " jam " . $interval->i . " menit";
        }
        $status_sla = 'TEPAT WAKTU';
        $status_class = 'status-tepat';
        $total_tepat++;
    }
    
    $tgl_masuk = $waktu_masuk_obj->format('d-m-Y');
    
    $data_paket[] = array(
        'resi' => $resi,
        'penerima' => $penerima,
        'tipe' => $tipe,
        'tgl_masuk' => $tgl_masuk,
        'jam_masuk' => $jam_masuk,
        'label_batas' => $label_batas,
        'waktu_tersisa' => $waktu_tersisa,
        'status_sla' => $status_sla,
        'status_class' => $status_class
    );
}

// Convert ke JSON untuk filter di JavaScript
$data_json = json_encode($data_paket);
?>

<script>
const semuaData = <?php echo $data_json; ?>;
let dataFilter = 'semua';

function displayTable(filter) {
    const tabel = document.getElementById('tabelSLA');
    const tbody = tabel.querySelector('tbody');
    if (tbody) tbody.remove();
    
    const newTbody = document.createElement('tbody');
    
    semuaData.forEach(function(p) {
        if (filter === 'semua' || 
            (filter === 'terlambat' && p.status_sla === 'TERLAMBAT') ||
            (filter === 'tepat' && p.status_sla === 'TEPAT WAKTU')) {
            
            const row = tabel.insertRow();
            row.innerHTML = `
                <td>${p.resi}</td>
                <td>${p.penerima}</td>
                <td>${p.tipe}</td>
                <td>${p.tgl_masuk}</td>
                <td>${p.jam_masuk}</td>
                <td>${p.label_batas}</td>
                <td>${p.waktu_tersisa}</td>
                <td class="${p.status_class}">${p.status_sla}</td>
            `;
        }
    });
}

function filterStatus(filter) {
    dataFilter = filter;
    displayTable(filter);
    
    // Update active button
    document.querySelectorAll('.filter-btn').forEach(btn => {
        btn.classList.remove('active');
    });
    event.target.classList.add('active');
}

// Update summary
document.getElementById('total-menunggu').textContent = <?php echo $total_menunggu; ?>;
document.getElementById('total-terlambat').textContent = <?php echo $total_terlambat; ?>;
document.getElementById('total-tepat').textContent = <?php echo $total_tepat; ?>;

// Initial display
displayTable('semua');
</script>

</body>
</html>
